/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.iview.client;

import com.firefly.iview.Image;
import com.firefly.iview.Template;
import com.firefly.iview.Work;
import com.firefly.iview.client.dto.ImageQueryInput;
import com.firefly.iview.client.dto.TemplateQueryInput;
import com.firefly.iview.client.dto.WorkQueryInput;
import java.util.List;
import javax.annotation.Nullable;
import org.beast.data.message.ReturnResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value="firefly-iview")
public interface IViewClient {
    @GetMapping(value={"/api/images/{id}"})
    public ReturnResult<Image> getImage(@PathVariable String var1);

    @GetMapping(value={"/api/images"})
    public ReturnResult<List<Image>> queryImagesBy(@SpringQueryMap ImageQueryInput var1, Pageable var2, @Nullable @RequestParam(value="after") String var3);

    @GetMapping(value={"/api/images/count"})
    public ReturnResult<Long> countImagesBy(@SpringQueryMap ImageQueryInput var1);

    @GetMapping(value={"/api/templates"})
    public ReturnResult<List<Template>> queryTemplatesBy(@SpringQueryMap TemplateQueryInput var1);

    @GetMapping(value={"/api/templates"})
    public ReturnResult<List<Template>> queryTemplatesBy(@SpringQueryMap TemplateQueryInput var1, Pageable var2, @Nullable @RequestParam(value="after") String var3);

    @GetMapping(value={"/api/templates/count"})
    public ReturnResult<Long> countTemplatesBy(@SpringQueryMap TemplateQueryInput var1);

    @GetMapping(value={"/api/templates/{id}"})
    public ReturnResult<Template> getTemplate(@PathVariable String var1);

    @GetMapping(value={"/api/works"})
    public ReturnResult<List<Work>> queryWorksBy(@SpringQueryMap WorkQueryInput var1, Pageable var2);

    @GetMapping(value={"/api/works"})
    public ReturnResult<List<Work>> queryWorksBy(@SpringQueryMap WorkQueryInput var1, Pageable var2, @Nullable @RequestParam(value="after") String var3);

    @GetMapping(value={"/api/works/count"})
    public ReturnResult<Long> countWorksBy(@SpringQueryMap WorkQueryInput var1);

    @PostMapping(value={"/api/works"})
    public ReturnResult<Work> postWork(@RequestBody Work var1);

    @GetMapping(value={"/api/works/{id}"})
    public ReturnResult<Work> getWork(@PathVariable String var1);

    @PutMapping(value={"/api/works/{id}"})
    public ReturnResult<Work> putWork(@PathVariable String var1, @RequestBody Work var2);

    @PatchMapping(value={"/api/works/{id}"})
    public ReturnResult<Work> patchWork(@PathVariable String var1, @RequestBody Work var2);

    @DeleteMapping(value={"/api/works/{id}"})
    public ReturnResult<Work> removeWork(@PathVariable String var1);
}

