package com.firefly.inclination.client;

import com.firefly.inclination.client.dto.AppInclination;
import com.firefly.inclination.client.dto.AppInclinationQueryInput;
import com.firefly.inclination.client.dto.OwnerInclinationIdentifierInput;
import org.beast.data.message.ReturnResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@FeignClient("firefly-inclination")
public interface AppInclinationClient {

    @GetMapping("/api/apps/{appId}/{namespace}/inclinations")
    ReturnResult<List<AppInclination>> queryInclinationBy(
            @PathVariable String appId,
            @PathVariable String namespace,
            @SpringQueryMap AppInclinationQueryInput input
    );

    @GetMapping("/api/apps/{appId}/{namespace}/inclinations/count")
    ReturnResult<Long> countInclinationBy(
            @PathVariable String appId,
            @PathVariable String namespace,
            @SpringQueryMap AppInclinationQueryInput input
    );



    @PostMapping("/api/apps/{appId}/{namespace}/inclinations")
    ReturnResult<AppInclination> createInclinationBy(
            @PathVariable String appId,
            @PathVariable String namespace,
            @RequestBody AppInclination input
    );


    @GetMapping("/api/apps/{appId}/{namespace}/inclinations/owner-inclination")
    ReturnResult<AppInclination> getOwnerInclinationBy(
            @PathVariable String appId,
            @PathVariable String namespace,
            @SpringQueryMap OwnerInclinationIdentifierInput input
    );
    @DeleteMapping("/api/apps/{appId}/{namespace}/inclinations/owner-inclination")
    ReturnResult<AppInclination> deleteOwnerInclinationBy(
            @PathVariable String appId,
            @PathVariable String namespace,
            @SpringQueryMap OwnerInclinationIdentifierInput input
    );

}
