package com.firefly.inclination.client;

import com.firefly.inclination.client.dto.AppUserInclination;
import com.firefly.inclination.client.dto.AppUserInclinationQueryInput;
import com.firefly.inclination.client.dto.GetOwnerInclinationInput;
import org.beast.data.message.ReturnResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

import java.util.List;

@FeignClient("firefly-inclination")
public interface AppInclinationClient {

    @GetMapping("/api/apps/{appId}/{namespace}/inclinations")
    ReturnResult<List<AppUserInclination>> queryInclinationBy(
            @PathVariable String appId,
            @PathVariable String namespace,
            @SpringQueryMap AppUserInclinationQueryInput input
    );

    @GetMapping("/api/apps/{appId}/{namespace}/inclinations/count")
    ReturnResult<Long> countInclinationBy(
            @PathVariable String appId,
            @PathVariable String namespace,
            @SpringQueryMap AppUserInclinationQueryInput input
    );

    @GetMapping("/api/apps/{appId}/{namespace}/inclination")
    ReturnResult<AppUserInclination> getInclinationBy(
            @PathVariable String appId,
            @PathVariable String namespace,
            @SpringQueryMap GetOwnerInclinationInput input
    );

}
