package com.firefly.iform.client.dto;

import com.firefly.iform.data.FormItem;
import lombok.Data;
import org.springframework.lang.Nullable;

import javax.validation.constraints.Size;
import java.time.Instant;
import java.util.List;
import java.util.Map;

@Data
public class Form {

    private String appId;

    //组别： 可结合用于划分权限或其他, 不允许修改
    private String group;

    //标识组别下 唯一
    private String name;

    private Map<String, String> metadata;

    private String title;

    @Nullable
    private String description;

    @Size(max = 50)
    private List<FormItem> items;

    private Instant createdAt;
}
