package com.firefly.iform.client;

import com.firefly.iform.client.dto.Form;
import com.firefly.iform.client.dto.FormQueryInput;
import org.beast.data.message.ReturnResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@FeignClient("firefly-form")
public interface FormClient {

    @GetMapping("/api/forms")
    ReturnResult<List<Form>> queryFormsBy(
            @SpringQueryMap FormQueryInput input
    );

    @PostMapping("/api/forms")
    ReturnResult<Form> postForm(
            @RequestBody Form input
    );

    @GetMapping("/api/forms/{id}")
    ReturnResult<Form> getFormById(@PathVariable String id);

    @PutMapping("/api/forms/{id}")
    ReturnResult<Form> putFormById(@PathVariable String id, @RequestBody Form form);

    @DeleteMapping("/api/forms/{id}")
    ReturnResult deleteById(@PathVariable String id);
}
