package com.firefly.iform.client;

import com.firefly.iform.client.dto.Form;
import com.firefly.iform.client.dto.FormData;
import com.firefly.iform.client.dto.FormSubmit;
import org.beast.data.message.ReturnResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

@FeignClient("firefly-form")
public interface AppFormClient {

    @GetMapping("/api/apps/{app}/forms/{group}/{name}")
    ReturnResult<Form> getForm(
            @PathVariable String app,
            @PathVariable String group,
            @PathVariable String name
    );

    @PatchMapping("/api/apps/{app}/forms/{group}/{name}")
    ReturnResult<Form> patchForm(
            @PathVariable String app,
            @PathVariable String group,
            @PathVariable String name,
            @RequestBody Form input
    );

    @PostMapping("/api/apps/{app}/forms/{group}/{name}/submit")
    ReturnResult<FormData> submitFormData(
            @PathVariable String app,
            @PathVariable String group,
            @PathVariable String name,
            @RequestBody FormSubmit submit
    );
}
