package com.firefly.iapp.security.web;

import com.firefly.iapp.security.CustomerAuthorizationManager;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.DispatcherServlet;

import javax.servlet.Servlet;

@Configuration(
        proxyBeanMethods = false
)
@ConditionalOnWebApplication(type = ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass({ Servlet.class, DispatcherServlet.class})
@AutoConfigureBefore({WebMvcAutoConfiguration.class})
public class IAppSecurityWebAutoConfiguration {

    @ConditionalOnBean(CustomerAuthorizationManager.class)
    @Bean
    public CustomerUserTokenResolver customerUserTokenResolver(CustomerAuthorizationManager authorizationManager) {
        return new CustomerUserTokenResolver(authorizationManager);
    }

}
