package com.firefly.iapp.security;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import org.beast.security.core.UserToken;
import org.springframework.beans.BeanUtils;

@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@Data
public class CustomerUserToken extends UserToken{

    private String customerId;



    public static CustomerUserToken valueOf(
            UserToken token,
            String customerId
    ) {
        CustomerUserToken userToken = new CustomerUserToken();
        BeanUtils.copyProperties(token, userToken);
        userToken.customerId = customerId;
        return userToken;
    }
}
