package com.firefly.design.iview.client.dto;

import com.firefly.design.data.TemplateAttributes;
import com.firefly.design.data.TemplateStatus;
import com.firefly.design.data.TemplateType;
import com.firefly.design.si.Schema;
import feign.Param;
import lombok.Data;
import org.springframework.web.bind.annotation.RequestParam;

import javax.annotation.Nullable;
import java.util.List;

@Data
public class TemplateQueryInput {




    private List<String> ids;

    //模板类型
    private TemplateType type;

    //作品类型
    private String workType;

    //标签
    private List<String> tags;

    //样式风格
    private List<String> styles;

    //关键字
    private List<String> keywords;

    private String keyword;

    //文档类型
    private String doctype;

    private TemplateAttributes attributes;

    private TemplateStatus status;

//    private String metadataWorkType;

    private Schema documentSchema;

//    private DocumentQueryInput document;
    //后续在实现
    //TODO FieldQueryMapEncoder,BeanQueryMapEncoder 相关逻辑
    //
//    private Map<String, String> metadata;

//    @Param(value = "metadata[workType]")
//    public String getMetadataWorkType() {
//        return metadataWorkType;
//    }

    @Param(value = "document.schema")
    public Schema getDocumentSchema() {
        return documentSchema;
    }
}
