package com.firefly.design.iview.client;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.firefly.design.data.*;
import com.firefly.design.iview.client.dto.*;
import com.firefly.design.si.Document;
import com.firefly.design.si.Picture;
import org.beast.data.domain.PageResult;
import org.beast.data.message.ReturnResult;
import org.beast.data.relay.Connection;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Nullable;
import java.util.List;

@FeignClient("firefly-design-iview")
public interface IViewClient {

    @GetMapping("/api/audios/{id}")
    ReturnResult<Audio> getAudio(
            @PathVariable String id
    );

    @GetMapping("/api/audios")
    ReturnResult<List<Audio>> queryAudiosBy(
            @SpringQueryMap AudioQueryInput input,
            Pageable pageable,
            @Nullable @RequestParam("after") String after
    );
    @GetMapping("/api/audios/count")
    ReturnResult<Long> countAudiosBy(
            @SpringQueryMap AudioQueryInput input
    );

    @GetMapping("/api/images/{id}")
    ReturnResult<Image> getImage(
            @PathVariable String id
    );

    @GetMapping("/api/images")
    ReturnResult<List<Image>> queryImagesBy(
            @SpringQueryMap ImageQueryInput input,
            Pageable pageable,
            @Nullable @RequestParam("after") String after
    );
    @GetMapping("/api/images/count")
    ReturnResult<Long> countImagesBy(
            @SpringQueryMap ImageQueryInput input
    );

    @GetMapping("/api/document-objects")
    ReturnResult<List<DocumentObject>> findDocumentsByIds(
            @RequestParam List<String> ids
    );

    @PostMapping("/api/document-objects")
    ReturnResult<DocumentObject> createDocumentObject(
            @RequestBody DocumentObject input
    );

    @PostMapping("/api/document-objects/{id}/detach")
    ReturnResult<DocumentObject> detachDocumentObject(
            @PathVariable String id
    );

    @PostMapping("/api/document-objects/copy={copyId}")
    ReturnResult<DocumentObject> cloneDocumentObject(
            @PathVariable String copyId,
            @RequestBody DocumentCopyInput input
    );
    @GetMapping("/api/document-objects/{id}")
    ReturnResult<DocumentObject> findDocumentObjectById(
            @PathVariable String id
    );

    @GetMapping("/api/document-objects/{id}/document")
    ReturnResult<Document> getDocumentById(
            @PathVariable String id
    );

    @PostMapping("/api/document-objects/{id}/document")
    ReturnResult<Document> saveDocument(
            @PathVariable String id,
            @RequestBody Document input
    );


    @GetMapping("/api/templates")
    ReturnResult<List<Template>> findTemplatesBy(
            @SpringQueryMap TemplateQuerySliceInput input,
            Pageable pageable
    );

    @GetMapping("/api/templates/page")
    ReturnResult<PageResult<Template>> findTemplatesPageBy(
            @SpringQueryMap TemplateQuerySliceInput input,
            Pageable pageable
    );

    @GetMapping("/api/templates/count")
    ReturnResult<Long> countTemplatesBy(
            @SpringQueryMap TemplateQueryInput input
    );

    @GetMapping("/api/templates/{id}")
    ReturnResult<Template> getTemplateById(
            @PathVariable String id
    );

    @GetMapping("/api/templates/first")
    ReturnResult<Template> findFirstTemplate(
        @SpringQueryMap TemplateQueryInput input
    );

    @GetMapping("/api/templates/last")
    ReturnResult<Template> findLastTemplate(
            @SpringQueryMap TemplateQueryInput input
    );

    @GetMapping("/api/templates/connection")
    ReturnResult<Connection<Template>> connectTemplate(
            @SpringQueryMap TemplateQueryInput input,
            org.beast.data.relay.Pageable pageable

    );

//    @GetMapping("/api/works")
//    ReturnResult<List<Work>> queryWorksBy(
//            @SpringQueryMap WorkQueryInput input,
//            Pageable pageable
//    );


    @GetMapping("/api/works")
    ReturnResult<List<Work>> findWorksByIdIn(@RequestParam("ids") List<String> ids);

    @GetMapping("/api/works")
    ReturnResult<List<Work>> findWorksBy(
         @SpringQueryMap WorkQueryInput input,
         Pageable pageable,
         @Nullable @RequestParam("after") String after
    );

    @GetMapping("/api/works/count")
    ReturnResult<Long> countWorksBy(
            @SpringQueryMap WorkQueryInput input
    );

    @PostMapping("/api/works")
    ReturnResult<Work> createWork(
            @RequestBody Work input
    );
    @PostMapping("/api/works/by-document")
    ReturnResult<Work> createWorkByDocument(
            @RequestBody CreateWorkByDocument input
    );

    @GetMapping("/api/works/{id}")
    ReturnResult<Work> getWorkById(
            @PathVariable String id
    );

    @PutMapping("/api/works/{id}")
    ReturnResult<Work> saveWork(
            @PathVariable String id,
            @RequestBody Work input
    );

    @PatchMapping("/api/works/{id}")
    ReturnResult<Work> patchWork(
            @PathVariable String id,
            @RequestBody Work input
    );

    @PostMapping("/api/works/{id}/discard")
    ReturnResult<Void> discardWorkById(
            @PathVariable String id
    );

    @DeleteMapping("/api/works/{id}")
    ReturnResult<Work> deleteWorkById(
            @PathVariable String id
    );

    @PostMapping("/api/works/{id}/transfer")
    ReturnResult<Void> transferWork(
            @PathVariable String id,
            @RequestBody WorkTransfer input
    );

    @GetMapping("/api/works/{id}/cover")
    ReturnResult<Picture> getWorkCover(
            @PathVariable String id
    );

    @PostMapping("/api/works/{id}/render/cover")
    ReturnResult<Picture> renderWorkCover(
            @PathVariable String id
    );

    @PostMapping("/api/works/{id}/render")
    ReturnResult<Picture> renderWork(
            @PathVariable String id
    );

    @GetMapping("/api/works/{id}/release-page")
    ReturnResult<Page> findReleaseWorkPage(
            @PathVariable String id
    );
    @PostMapping("/api/works/{id}/release-page")
    ReturnResult<Page> releaseWorkPage(
            @PathVariable String id,
            @RequestBody ReleasePageInput input
    );
    @PostMapping("/api/works/{id}/share")
    ReturnResult<Share> shareWork(
            @PathVariable String id
    );

    @GetMapping("/api/pages")
    ReturnResult<List<Page>> findPagesByIdIn(@RequestParam("ids") List<String> ids);


    @GetMapping("/api/pages/{id}")
    ReturnResult<Page> findPageById(
            @PathVariable String id
    );
    @GetMapping("/api/pages/source={sourceId}")
    ReturnResult<Page> findPageBySource(
            @PathVariable String sourceId
    );
    @GetMapping("/api/pages/sources={sourceIds}")
    ReturnResult<List<Page>> findPagesBySourceIn(
            @PathVariable List<String> sourceIds
    );
    @PutMapping("/api/pages/{id}")
    ReturnResult<Page> putPage(
            @PathVariable String id,
            @RequestBody Page page
    );
    @PatchMapping("/api/pages/{id}")
    ReturnResult<Page> savePage(
            @PathVariable String id,
            @RequestBody Page page
    );
    @PatchMapping("/api/pages/{id}")
    ReturnResult<Page> patchPage(
            @PathVariable String id,
            @RequestBody Page page
    );
    @PatchMapping("/api/pages/{id}")
    ReturnResult<Page> savePageById(
            @PathVariable String id,
            @RequestBody ObjectNode node
    );

    @DeleteMapping("/api/works/{id}")
    ReturnResult<Page> deletePageById(
            @PathVariable String id
    );

    @PostMapping("/api/pages/{id}/share-poster")
    ReturnResult<Picture> renderSharePoster(
            @PathVariable String id,
            @RequestBody CreateSharePosterInput input
    );

    @PostMapping("/api/pages/{id}/qrcode-share-poster")
    ReturnResult<Picture> renderQRCodeSharePoster(
            @PathVariable String id,
            @RequestBody CreateQRCodeSharePosterInput input
    );


    @PostMapping("/api/pages/{id}/visit")
    ReturnResult<?> visitPage(
            @PathVariable String id,
            @RequestBody ViewVisit visit
    );
    @GetMapping("/api/shares/{id}")
    ReturnResult<Share> findShareById(
            @PathVariable String id
    );


    @GetMapping("/api/shares/target={targetId}")
    ReturnResult<Share> findShareByTarget(
            @PathVariable String targetId
    );
}
