/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.design.iview.client;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.firefly.design.data.Audio;
import com.firefly.design.data.CreateWorkByDocument;
import com.firefly.design.data.DocumentObject;
import com.firefly.design.data.Image;
import com.firefly.design.data.Page;
import com.firefly.design.data.Share;
import com.firefly.design.data.Template;
import com.firefly.design.data.ViewVisit;
import com.firefly.design.data.Work;
import com.firefly.design.iview.client.dto.AudioQueryInput;
import com.firefly.design.iview.client.dto.DocumentCopyInput;
import com.firefly.design.iview.client.dto.ImageQueryInput;
import com.firefly.design.iview.client.dto.ReleasePageInput;
import com.firefly.design.iview.client.dto.TemplateQueryInput;
import com.firefly.design.iview.client.dto.WorkQueryInput;
import com.firefly.design.si.Document;
import com.firefly.design.si.Picture;
import java.util.List;
import javax.annotation.Nullable;
import org.beast.data.message.ReturnResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value="firefly-design-iview")
public interface IViewClient {
    @GetMapping(value={"/api/audios/{id}"})
    public ReturnResult<Audio> getAudio(@PathVariable String var1);

    @GetMapping(value={"/api/audios"})
    public ReturnResult<List<Audio>> queryAudiosBy(@SpringQueryMap AudioQueryInput var1, Pageable var2, @Nullable @RequestParam(value="after") String var3);

    @GetMapping(value={"/api/audios/count"})
    public ReturnResult<Long> countAudiosBy(@SpringQueryMap AudioQueryInput var1);

    @GetMapping(value={"/api/images/{id}"})
    public ReturnResult<Image> getImage(@PathVariable String var1);

    @GetMapping(value={"/api/images"})
    public ReturnResult<List<Image>> queryImagesBy(@SpringQueryMap ImageQueryInput var1, Pageable var2, @Nullable @RequestParam(value="after") String var3);

    @GetMapping(value={"/api/images/count"})
    public ReturnResult<Long> countImagesBy(@SpringQueryMap ImageQueryInput var1);

    @GetMapping(value={"/api/document-objects"})
    public ReturnResult<List<DocumentObject>> findDocumentsByIds(@RequestParam List<String> var1);

    @PostMapping(value={"/api/document-objects"})
    public ReturnResult<DocumentObject> createDocumentObject(@RequestBody DocumentObject var1);

    @PostMapping(value={"/api/document-objects/{id}/detach"})
    public ReturnResult<DocumentObject> detachDocumentObject(@PathVariable String var1);

    @PostMapping(value={"/api/document-objects/copy={copyId}"})
    public ReturnResult<DocumentObject> cloneDocumentObject(@PathVariable String var1, @RequestBody DocumentCopyInput var2);

    @GetMapping(value={"/api/document-objects/{id}"})
    public ReturnResult<DocumentObject> findDocumentObjectById(@PathVariable String var1);

    @GetMapping(value={"/api/document-objects/{id}/document"})
    public ReturnResult<Document> getDocumentById(@PathVariable String var1);

    @PostMapping(value={"/api/document-objects/{id}/document"})
    public ReturnResult<Document> saveDocument(@PathVariable String var1, @RequestBody Document var2);

    @GetMapping(value={"/api/templates"})
    public ReturnResult<List<Template>> queryTemplatesBy(@SpringQueryMap TemplateQueryInput var1);

    @GetMapping(value={"/api/templates"})
    public ReturnResult<List<Template>> queryTemplatesBy(@SpringQueryMap TemplateQueryInput var1, Pageable var2, @Nullable @RequestParam(value="after") String var3);

    @GetMapping(value={"/api/templates/count"})
    public ReturnResult<Long> countTemplatesBy(@SpringQueryMap TemplateQueryInput var1);

    @GetMapping(value={"/api/templates/{id}"})
    public ReturnResult<Template> getTemplateById(@PathVariable String var1);

    @GetMapping(value={"/api/works"})
    public ReturnResult<List<Work>> findWorksByIdIn(@RequestParam(value="ids") List<String> var1);

    @GetMapping(value={"/api/works"})
    public ReturnResult<List<Work>> findWorksBy(@SpringQueryMap WorkQueryInput var1, Pageable var2, @Nullable @RequestParam(value="after") String var3);

    @GetMapping(value={"/api/works/count"})
    public ReturnResult<Long> countWorksBy(@SpringQueryMap WorkQueryInput var1);

    @PostMapping(value={"/api/works"})
    public ReturnResult<Work> createWork(@RequestBody Work var1);

    @PostMapping(value={"/api/works/by-document"})
    public ReturnResult<Work> createWorkByDocument(@RequestBody CreateWorkByDocument var1);

    @GetMapping(value={"/api/works/{id}"})
    public ReturnResult<Work> getWorkById(@PathVariable String var1);

    @PutMapping(value={"/api/works/{id}"})
    public ReturnResult<Work> saveWork(@PathVariable String var1, @RequestBody Work var2);

    @PatchMapping(value={"/api/works/{id}"})
    public ReturnResult<Work> patchWork(@PathVariable String var1, @RequestBody Work var2);

    @DeleteMapping(value={"/api/works/{id}"})
    public ReturnResult<Work> removeWork(@PathVariable String var1);

    @PostMapping(value={"/api/works/{id}/render-cover"})
    public ReturnResult<Picture> renderWorkCover(@PathVariable String var1);

    @PostMapping(value={"/api/works/{id}/render"})
    public ReturnResult<Picture> render(@PathVariable String var1);

    @PostMapping(value={"/api/works/{id}/release-page"})
    public ReturnResult<Page> releaseWorkPage(@PathVariable String var1, @RequestBody ReleasePageInput var2);

    @PostMapping(value={"/api/works/{id}/share"})
    public ReturnResult<Share> shareWork(@PathVariable String var1);

    @GetMapping(value={"/api/pages"})
    public ReturnResult<List<Page>> findPagesByIdIn(@RequestParam(value="ids") List<String> var1);

    @GetMapping(value={"/api/pages/{id}"})
    public ReturnResult<Page> findPageById(@PathVariable String var1);

    @GetMapping(value={"/api/pages/source={sourceId}"})
    public ReturnResult<Page> findPageBySource(@PathVariable String var1);

    @GetMapping(value={"/api/pages/sources={sourceIds}"})
    public ReturnResult<List<Page>> findPagesBySourceIn(@PathVariable List<String> var1);

    @PutMapping(value={"/api/pages/{id}"})
    public ReturnResult<Page> putPage(@PathVariable String var1, @RequestBody Page var2);

    @PatchMapping(value={"/api/pages/{id}"})
    public ReturnResult<Page> savePage(@PathVariable String var1, @RequestBody Page var2);

    @PatchMapping(value={"/api/pages/{id}"})
    public ReturnResult<Page> patchPage(@PathVariable String var1, @RequestBody Page var2);

    @PatchMapping(value={"/api/pages/{id}"})
    public ReturnResult<Page> patchPage(@PathVariable String var1, @RequestBody ObjectNode var2);

    @PostMapping(value={"/api/pages/{id}/share-poster"})
    public ReturnResult<Picture> renderSharePoster(@PathVariable String var1);

    @PostMapping(value={"/api/pages/{id}/visit"})
    public ReturnResult<?> visitPage(@PathVariable String var1, @RequestBody ViewVisit var2);

    @GetMapping(value={"/api/shares/{id}"})
    public ReturnResult<Share> findShareById(@PathVariable String var1);

    @GetMapping(value={"/api/shares/target={targetId}"})
    public ReturnResult<Share> findShareByTarget(@PathVariable String var1);
}

