package com.firefly.design.iview.client;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.firefly.design.data.*;
import com.firefly.design.iview.client.dto.*;
import com.firefly.design.si.Document;
import com.firefly.design.si.Picture;
import org.beast.data.message.ReturnResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Nullable;
import java.util.List;

@FeignClient("firefly-design-iview")
public interface IViewClient {

    @GetMapping("/api/audios/{id}")
    ReturnResult<Audio> getAudio(
            @PathVariable String id
    );

    @GetMapping("/api/audios")
    ReturnResult<List<Audio>> queryAudiosBy(
            @SpringQueryMap AudioQueryInput input,
            Pageable pageable,
            @Nullable @RequestParam("after") String after
    );
    @GetMapping("/api/audios/count")
    ReturnResult<Long> countAudiosBy(
            @SpringQueryMap AudioQueryInput input
    );

    @GetMapping("/api/images/{id}")
    ReturnResult<Image> getImage(
            @PathVariable String id
    );

    @GetMapping("/api/images")
    ReturnResult<List<Image>> queryImagesBy(
            @SpringQueryMap ImageQueryInput input,
            Pageable pageable,
            @Nullable @RequestParam("after") String after
    );
    @GetMapping("/api/images/count")
    ReturnResult<Long> countImagesBy(
            @SpringQueryMap ImageQueryInput input
    );

    @PostMapping("/api/document-objects")
    ReturnResult<DocumentObject> createDocumentObject(
            @RequestBody DocumentObject input
    );

    @PostMapping("/api/document-objects/copy={copyId}")
    ReturnResult<DocumentObject> cloneDocumentObject(
            @PathVariable String copyId,
            @RequestBody DocumentCopyInput input
    );

    @GetMapping("/api/document-objects/{id}/document")
    ReturnResult<Document> getDocumentById(
            @PathVariable String id
    );

    @PostMapping("/api/document-objects/{id}/document")
    ReturnResult<?> saveDocument(
            @PathVariable String id,
            @RequestBody Document input
    );


    @GetMapping("/api/templates")
    ReturnResult<List<Template>> queryTemplatesBy(
            @SpringQueryMap TemplateQueryInput input
    );
    @GetMapping("/api/templates")
    ReturnResult<List<Template>> queryTemplatesBy(
            @SpringQueryMap TemplateQueryInput input,
            Pageable pageable,
            @Nullable @RequestParam("after") String after
    );

    @GetMapping("/api/templates/count")
    ReturnResult<Long> countTemplatesBy(
            @SpringQueryMap TemplateQueryInput input
    );

    @GetMapping("/api/templates/{id}")
    ReturnResult<Template> getTemplate(
            @PathVariable String id
    );

    @GetMapping("/api/works")
    ReturnResult<List<Work>> queryWorksBy(
            @SpringQueryMap WorkQueryInput input,
            Pageable pageable
    );
    @GetMapping("/api/works")
    ReturnResult<List<Work>> queryWorksBy(
         @SpringQueryMap WorkQueryInput input,
         Pageable pageable,
         @Nullable @RequestParam("after") String after
    );

    @GetMapping("/api/works/count")
    ReturnResult<Long> countWorksBy(
            @SpringQueryMap WorkQueryInput input
    );

    @PostMapping("/api/works")
    ReturnResult<Work> postWork(
            @RequestBody Work input
    );

    @GetMapping("/api/works/{id}")
    ReturnResult<Work> getWork(
            @PathVariable String id
    );

    @PutMapping("/api/works/{id}")
    ReturnResult<Work> putWork(
            @PathVariable String id,
            @RequestBody Work input
    );

    @PatchMapping("/api/works/{id}")
    ReturnResult<Work> patchWork(
            @PathVariable String id,
            @RequestBody Work input
    );

    @DeleteMapping("/api/works/{id}")
    ReturnResult<Work> removeWork(
            @PathVariable String id
    );

    @PostMapping("/api/works/{id}/render")
    ReturnResult<Picture> render(
            @PathVariable String id
    );

    @PostMapping("/api/works/{id}/release-page")
    ReturnResult<Page> releaseWorkPage(
            @PathVariable String id,
            @RequestBody ReleasePageInput input
    );
    @PostMapping("/api/works/{id}/share")
    ReturnResult<Share> shareWork(
            @PathVariable String id
    );

    @GetMapping("/api/pages/{id}")
    ReturnResult<Page> findPageById(
            @PathVariable String id
    );
    @GetMapping("/api/pages/source={sourceId}")
    ReturnResult<Page> findPageBySource(
            @PathVariable String sourceId
    );
    @PutMapping("/api/pages/{id}")
    ReturnResult<Page> putPage(
            @PathVariable String id,
            @RequestBody Page page
    );
    @PatchMapping("/api/pages/{id}")
    ReturnResult<Page> savePage(
            @PathVariable String id,
            @RequestBody Page page
    );
    @PatchMapping("/api/pages/{id}")
    ReturnResult<Page> patchPage(
            @PathVariable String id,
            @RequestBody Page page
    );
    @PatchMapping("/api/pages/{id}")
    ReturnResult<Page> patchPage(
            @PathVariable String id,
            @RequestBody ObjectNode node
    );

    @GetMapping("/api/shares/{id}")
    ReturnResult<Share> findShareById(
            @PathVariable String id
    );


    @GetMapping("/api/shares/target={targetId}")
    ReturnResult<Share> findShareByTarget(
            @PathVariable String targetId
    );
}
