package com.firefly.design.si;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 页面-文档
 * - logo设计
 *
 */
@ToString
@EqualsAndHashCode(callSuper = true)
@Data
public class PageDocument extends Document implements Serializable {


    private PageTheme theme;

    private PageCustomization customization;

    private Autoplay autoplay;

    //默认标准  转为viewport width 按比展示
    private Integer width;

    private Integer height;

    private Background background;

    private Music backgroundMusic;


    private Envelope envelope;

    private List<PageLayout> layouts = new ArrayList<>();


    @Override
    public Dimension dimension() {
        return new Dimension(width, height);
    }
}
