package com.firefly.design.render;

import lombok.Data;

import java.util.List;

@Data
public class RenderContent {

    private RenderContentType type;

    private String id;

    private List<Integer> pickPages;
//    private List<Number> pages;

    public static RenderContent ofDocumentReference(String documentId) {
        var content = new RenderContent();
        content.setType(RenderContentType.DOCUMENT_REFERENCE);
        content.setId(documentId);
        return content;
    }

}
