package com.firefly.design.iform.data;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;

import java.util.HashMap;
import java.util.Map;

/**
 * 互动元素
 */
@Data
public class FormItemControl {

    private String name;

    private Map<String, Object> properties = new HashMap<>();

    @JsonIgnore
    private Map<String, Object> attributes = new HashMap<>();


    @JsonAnyGetter
    public Map<String, Object> other() {
        return this.attributes;
    }

    @JsonAnySetter
    public void setOther(String key, Object value) {
        this.attributes.put(key, value);
    }

}
