package com.firefly.design.data;

import com.firefly.design.si.Document;
import com.firefly.design.util.Documents;
import lombok.Data;
import lombok.ToString;

/**
 * 模板属性
 */
@ToString
@Data
public class TemplateAttributes {


    /**
     * 可替换图片数量
     */
    private Integer replaceableImageCount;


    public static TemplateAttributes valueOf(Document document) {
        TemplateAttributes attributes = new TemplateAttributes();
        attributes.setReplaceableImageCount(Documents.countReplaceableImageCount(document));
        return attributes;
    }
}
