/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.design.util;

import com.firefly.design.si.Document;
import com.firefly.design.si.Element;
import com.firefly.design.si.ImageDocument;
import com.firefly.design.si.PageDocument;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.springframework.util.ObjectUtils;

public class Documents {
    private static int MAX_DEPTH = 20;
    public static Set<String> IMAGE_TAGS = Sets.newHashSet((Object[])new String[]{"Image", "ClippathImage"});

    private static void walkEach(int depth, Iterable<Element> elements, Consumer<Element> consumer, Predicate<Element> preventDepth) {
        for (Element element : elements) {
            consumer.accept(element);
            List<Element> children = element.getChildren();
            if (depth >= MAX_DEPTH || ObjectUtils.isEmpty(children) || !preventDepth.test(element)) continue;
            Documents.walkEach(depth + 1, children, consumer, preventDepth);
        }
    }

    public static void walk(Iterable<Element> elements, Consumer<Element> consumer, Predicate<Element> preventDepth) {
        Documents.walkEach(1, elements, consumer, preventDepth);
    }

    public static void walk(Iterable<Element> elements, Consumer<Element> consumer) {
        Documents.walkEach(1, elements, consumer, element -> true);
    }

    public static void walkElement(Document document, Consumer<Element> consumer) {
        if (document instanceof PageDocument) {
            PageDocument pageDocument = (PageDocument)document;
            pageDocument.getLayouts().forEach(layout -> Documents.walk(layout.getElements(), consumer));
        } else if (document instanceof ImageDocument) {
            ImageDocument imageDocument = (ImageDocument)document;
            Documents.walk(imageDocument.getElements(), consumer);
        }
    }

    public static int countReplaceableImageCount(Iterable<Element> elements) {
        AtomicInteger count = new AtomicInteger();
        Documents.walk(elements, element -> {
            Map<String, Object> editable;
            String as = element.getAs();
            if (IMAGE_TAGS.contains(as) && Objects.nonNull(editable = element.getEditable()) && Objects.equals(editable.get("replaceable"), Boolean.TRUE)) {
                count.incrementAndGet();
            }
        });
        return count.get();
    }

    public static int countReplaceableImageCount(Document document) {
        AtomicInteger count = new AtomicInteger();
        if (document instanceof PageDocument) {
            PageDocument pageDocument = (PageDocument)document;
            pageDocument.getLayouts().forEach(layout -> count.set(count.get() + Documents.countReplaceableImageCount(layout.getElements())));
        } else if (document instanceof ImageDocument) {
            ImageDocument imageDocument = (ImageDocument)document;
            count.set(Documents.countReplaceableImageCount(imageDocument.getElements()));
        }
        return count.get();
    }

    public static int countLayouts(Document document) {
        if (document instanceof PageDocument) {
            PageDocument pageDocument = (PageDocument)document;
            return pageDocument.getLayouts().size();
        }
        return 1;
    }
}

