package com.firefly.design.si;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;


/**
 * 页面布局-文档
 * 如：信封， 封面等单页
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class PageLayoutDocument extends Document implements Serializable {

    private Integer width;

    private Integer height;

    private Background background;

    private List<Element> elements;

    @Override
    public Dimension dimension() {
        return new Dimension(width, height);
    }
}
