package com.firefly.design.si;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.springframework.lang.Nullable;

import java.io.Serializable;


public class Dimension implements Cloneable, Serializable {

    public int width;
    public int height;


    public @Nullable String ruler;

    //用于序列化使用
    public Dimension() {
    }

    public Dimension(int width, int height) {
        this(width, height, null);
    }

    @JsonCreator
    public Dimension(@JsonProperty("width") int width, @JsonProperty("height") int height, @JsonProperty("ruler")  @Nullable String ruler) {
        this.width = width;
        this.height = height;
        this.ruler = ruler;
    }

    public int width() {
        return this.width;
    }
    public int height() {
        return this.height;
    }
    public String ruler() {
        return this.ruler;
    }

//    public void setWidth(int width) {
//        this.width = width;
//    }
//
//    public void setHeight(int height) {
//        this.height = height;
//    }
//
//    public void setRuler(@Nullable String ruler) {
//        this.ruler = ruler;
//    }

    public Object clone() {
        try {
            return super.clone();
        } catch (CloneNotSupportedException e) {
            // this shouldn't happen, since we are Cloneable
            throw new InternalError(e);
        }
    }
}
