package com.firefly.design.render;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import lombok.Data;

@JsonTypeInfo(
        use = JsonTypeInfo.Id.NAME,
        include = JsonTypeInfo.As.EXISTING_PROPERTY,
        property = "type",
        visible = true
)
@JsonSubTypes({
        @JsonSubTypes.Type(value = TurnLayoutsPlay.class, name = "turn"),
})
@Data
public abstract class LayoutsPlay {

    private String type;

    public LayoutsPlay(String type) {
        this.type = type;
    }
}
