package com.firefly.design.invitation.config;

import com.firefly.design.invitation.ConcatInvitation;
import com.firefly.design.invitation.InvitationAddress;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.util.Objects;

@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Getter
@Setter
public class ConcatInvitationConfig extends InvitationConfig{




    /**
     * 启用祝福
     */
    private boolean enabledComment = false;

    /**
     * 隐藏祝福弹幕
     */
    public boolean hiddenComment = false;

    /**
     * 禁止新的祝福弹幕
     */
    private boolean disabledNewComment = false;

    /**
     * 启用强制自动打开
     * - 当有音乐，自动播放失败时候。需设置true才会自动打开
     */
    private boolean enabledForceAutoOpen = false;


    /**
     * 封面文档ID
     */
    private String envelopeId;

    /**
     * 地址
     */
    private InvitationAddress address;

    public ConcatInvitationConfig() {
        super(ConcatInvitation.TYPE);
    }


    @Override
    public ConcatInvitationConfig clone() {
        ConcatInvitationConfig clone = (ConcatInvitationConfig) super.clone();
        clone.setPrimaryColor(this.getPrimaryColor());
//        clone.setDisabledAdvert(this.isDisabledAdvert());
        clone.setEnabledComment(this.enabledComment);
        clone.setHiddenComment(this.hiddenComment);
        clone.setDisabledNewComment(this.disabledNewComment);
        clone.setEnabledForceAutoOpen(this.enabledForceAutoOpen);
        clone.setEnvelopeId(this.envelopeId);
        if (Objects.nonNull(this.address)) {
            clone.setAddress(this.address.clone());
        }
        return clone;
    }

}
