package com.firefly.design.invitation;

import com.firefly.design.data.LngLat;
import lombok.Data;

@Data
public class InvitationAddress implements Cloneable {

    private LngLat lnglat;

    private String name;

    private String description;

    @Override
    public InvitationAddress clone() {
        try {
            InvitationAddress clone = (InvitationAddress) super.clone();
            clone.setLnglat(this.lnglat);
            clone.setName(this.name);
            clone.setDescription(this.description);
            return clone;
        } catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }
}
