package com.firefly.design.data;

import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;
import org.beast.security.core.SNSIdentity;
import org.beast.security.core.SNSUserToken;
import org.springframework.lang.Nullable;

import java.util.Objects;


@Builder
@Data
public class ReleaseScene {

    @Nullable
    private SNSIdentity sns;

    @Tolerate
    public ReleaseScene() {
    }


    public static ReleaseScene valueOf(SNSUserToken userToken) {
        var builder = ReleaseScene.builder();
        if (Objects.nonNull(userToken)) {
            var identity = SNSIdentity.valueOf(userToken);
            builder = builder.sns(identity);
        }
        return builder.build();
    }
}
