/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.design.data;

import com.firefly.design.si.Dimension;
import com.firefly.design.si.DocumentType;

public class DocumentDescription {
    private String schema;
    private String version;
    private DocumentType type;
    private Dimension dimension;
    private String md5;
    private long length;

    public DocumentDescription() {
    }

    public static DocumentDescription valueOf(String schema, String version, DocumentType type, Dimension dimension, String md5, long length) {
        return DocumentDescription.builder().schema(schema).version(version).type(type).dimension(dimension).md5(md5).length(length).build();
    }

    DocumentDescription(String schema, String version, DocumentType type, Dimension dimension, String md5, long length) {
        this.schema = schema;
        this.version = version;
        this.type = type;
        this.dimension = dimension;
        this.md5 = md5;
        this.length = length;
    }

    public static DocumentDescriptionBuilder builder() {
        return new DocumentDescriptionBuilder();
    }

    public String getSchema() {
        return this.schema;
    }

    public String getVersion() {
        return this.version;
    }

    public DocumentType getType() {
        return this.type;
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public String getMd5() {
        return this.md5;
    }

    public long getLength() {
        return this.length;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setType(DocumentType type) {
        this.type = type;
    }

    public void setDimension(Dimension dimension) {
        this.dimension = dimension;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DocumentDescription)) {
            return false;
        }
        DocumentDescription other = (DocumentDescription)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLength() != other.getLength()) {
            return false;
        }
        String this$schema = this.getSchema();
        String other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        DocumentType this$type = this.getType();
        DocumentType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Dimension this$dimension = this.getDimension();
        Dimension other$dimension = other.getDimension();
        if (this$dimension == null ? other$dimension != null : !this$dimension.equals(other$dimension)) {
            return false;
        }
        String this$md5 = this.getMd5();
        String other$md5 = other.getMd5();
        return !(this$md5 == null ? other$md5 != null : !this$md5.equals(other$md5));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DocumentDescription;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $length = this.getLength();
        result = result * 59 + (int)($length >>> 32 ^ $length);
        String $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        DocumentType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Dimension $dimension = this.getDimension();
        result = result * 59 + ($dimension == null ? 43 : $dimension.hashCode());
        String $md5 = this.getMd5();
        result = result * 59 + ($md5 == null ? 43 : $md5.hashCode());
        return result;
    }

    public String toString() {
        return "DocumentDescription(schema=" + this.getSchema() + ", version=" + this.getVersion() + ", type=" + this.getType() + ", dimension=" + this.getDimension() + ", md5=" + this.getMd5() + ", length=" + this.getLength() + ")";
    }

    public static class DocumentDescriptionBuilder {
        private String schema;
        private String version;
        private DocumentType type;
        private Dimension dimension;
        private String md5;
        private long length;

        DocumentDescriptionBuilder() {
        }

        public DocumentDescriptionBuilder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public DocumentDescriptionBuilder version(String version) {
            this.version = version;
            return this;
        }

        public DocumentDescriptionBuilder type(DocumentType type) {
            this.type = type;
            return this;
        }

        public DocumentDescriptionBuilder dimension(Dimension dimension) {
            this.dimension = dimension;
            return this;
        }

        public DocumentDescriptionBuilder md5(String md5) {
            this.md5 = md5;
            return this;
        }

        public DocumentDescriptionBuilder length(long length) {
            this.length = length;
            return this;
        }

        public DocumentDescription build() {
            return new DocumentDescription(this.schema, this.version, this.type, this.dimension, this.md5, this.length);
        }

        public String toString() {
            return "DocumentDescription.DocumentDescriptionBuilder(schema=" + this.schema + ", version=" + this.version + ", type=" + this.type + ", dimension=" + this.dimension + ", md5=" + this.md5 + ", length=" + this.length + ")";
        }
    }
}

