package com.firefly.design.si;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import lombok.Data;

import java.io.Serializable;
import java.util.List;


@JsonTypeInfo(
        use = JsonTypeInfo.Id.NAME,
        include = JsonTypeInfo.As.EXISTING_PROPERTY,
        property = "type",
        visible = true
)
@JsonSubTypes({
        @JsonSubTypes.Type(value = BackgroundDocument.class, name = "background"),
        @JsonSubTypes.Type(value = ElementDocument.class, name = "element"),
        @JsonSubTypes.Type(value = ImageDocument.class, name = "image"),
        @JsonSubTypes.Type(value = PageConcatDocument.class, name = "page/concat"),
        @JsonSubTypes.Type(value = PageTurnDocument.class, name = "page/turn"),
        @JsonSubTypes.Type(value = PageLayoutDocument.class, name = "page/layout"),
})
@Data
public abstract class Document implements Serializable {

//    private DocumentSchema schema;
    private String schema;

    private String version;

    private DocumentType type;

    //字体引用
    private List<FontFace> fonts;

    //图片素材资源引用


    public abstract Dimension dimension();

}
