package com.firefly.design.invitation.config;

import com.firefly.design.invitation.ImageInvitation;
import com.firefly.design.invitation.InvitationAddress;
import lombok.*;

import java.util.Objects;

@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Getter
@Setter
public class ImageInvitationConfig extends InvitationConfig{


    /**
     * 地址
     */
    private InvitationAddress address;

    public ImageInvitationConfig() {
        super(ImageInvitation.TYPE);
    }

    @Override
    public ImageInvitationConfig clone() {
        ImageInvitationConfig clone = (ImageInvitationConfig) super.clone();
        clone.setPrimaryColor(this.getPrimaryColor());
//        clone.setDisabledAdvert(this.isDisabledAdvert());
        if (Objects.nonNull(this.address)) {
            clone.setAddress(this.address.clone());
        }
        return clone;
    }
}
