package com.firefly.design.invitation;

import com.firefly.design.invitation.config.TurnInvitationConfig;
import com.firefly.design.si.Document;
import com.firefly.design.si.DocumentType;
import com.firefly.design.si.PageDocument;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import lombok.experimental.Delegate;
import org.springframework.lang.Nullable;

@ToString
@EqualsAndHashCode(callSuper = true)
@Data
public class TurnInvitation extends Invitation {

    public static final String TYPE_VALUE = "page/turn";
    public static final DocumentType TYPE = DocumentType.valueOf(TYPE_VALUE);
    /**
     * 选项
     */
    @Delegate(excludes = ConfigExcludes.class)
    private TurnInvitationConfig config;



    /**
     * 封面
     */
    @Nullable
    private Document envelope;

    /**
     * 内容
     */
    private Document content;


    @Data
    public static class ConfigExcludes {
        private DocumentType type;
    }

}
