package com.firefly.design.invitation;


import com.firefly.design.invitation.config.ImageInvitationConfig;
import com.firefly.design.invitation.config.TurnInvitationConfig;
import com.firefly.design.si.Document;
import com.firefly.design.si.DocumentType;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import lombok.experimental.Delegate;

@ToString
@EqualsAndHashCode(callSuper = true)
@Data
public class ImageInvitation extends Invitation {

    public static final String TYPE_VALUE = "image";
    public static final DocumentType TYPE = DocumentType.valueOf(TYPE_VALUE);

    /**
     * 选项
     */
    @Delegate(excludes = ImageInvitationConfigExcludes.class)
    private ImageInvitationConfig config;

    /**
     * 内容
     */
    private Document content;

    @Data
    public static class ImageInvitationConfigExcludes {
        private DocumentType type;
    }

}
