package com.firefly.design.invitation.config;


import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.firefly.design.invitation.ImageInvitation;
import com.firefly.design.invitation.TurnInvitation;
import com.firefly.design.si.DocumentType;
import lombok.Data;

@JsonTypeInfo(
        use = JsonTypeInfo.Id.NAME,
        include = JsonTypeInfo.As.EXISTING_PROPERTY,
        property = "type",
        visible = true
)
@JsonSubTypes({
        @JsonSubTypes.Type(value = TurnInvitationConfig.class, name = "page/turn"),
        @JsonSubTypes.Type(value = ImageInvitationConfig.class, name = "image"),
})
@Data
public abstract class InvitationConfig implements Cloneable{

    private DocumentType type;


    /**
     * 主色调，如弹幕颜色， 按钮颜色等
     */
    private String primaryColor;

    public InvitationConfig(DocumentType type) {
        this.type = type;
    }

    @Override
    public InvitationConfig clone() {
        try {
            return (InvitationConfig) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }
}
