package com.firefly.design.invitation.config;

import com.firefly.design.invitation.InvitationAddress;
import com.firefly.design.invitation.TurnAutoplay;
import com.firefly.design.si.DocumentType;
import lombok.*;

import java.util.Objects;

@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Getter
@Setter
public class ImageInvitationConfig extends InvitationConfig{


    /**
     * 地址
     */
    private InvitationAddress address;

    public static final DocumentType TYPE = DocumentType.valueOf("image");
    public ImageInvitationConfig() {
        super(TYPE);
    }

    @Override
    public ImageInvitationConfig clone() {
        ImageInvitationConfig clone = (ImageInvitationConfig) super.clone();
        clone.setPrimaryColor(this.getPrimaryColor());
//        clone.setDisabledAdvert(this.isDisabledAdvert());
        if (Objects.nonNull(this.address)) {
            clone.setAddress(this.address.clone());
        }
        return clone;
    }
}
