package com.firefly.design.invitation;

import lombok.Data;

import java.util.Objects;


@Data
public class InvitationSetting implements Cloneable {

    /**
     * 主颜色
     */
    private String primaryColor;

    /**
     * 启用祝福
     */
    private boolean enabledComment = false;

    /**
     * 隐藏祝福弹幕
     */
    public boolean hiddenComment = false;

    /**
     * 禁止新的祝福弹幕
     */
    private boolean disabledNewComment = false;

    /**
     * 启用强制自动打开
     * - 当有音乐，自动播放失败时候。需设置true才会自动打开
     */
    private boolean enabledForceAutoOpen = false;


    /**
     * 禁用推广
     * - 尾部
     */
    private boolean disabledAdvert;

    @Override
    public InvitationSetting clone() {
        try {
            InvitationSetting clone = (InvitationSetting) super.clone();
            clone.setPrimaryColor(this.primaryColor);
            clone.setDisabledAdvert(this.disabledAdvert);
            clone.setEnabledComment(this.enabledComment);
            clone.setHiddenComment(this.hiddenComment);
            clone.setDisabledNewComment(this.disabledNewComment);
            clone.setEnabledForceAutoOpen(this.enabledForceAutoOpen);
            return clone;
        } catch (CloneNotSupportedException e) {
            throw new AssertionError(e);
        }
    }

}
