package com.firefly.design.invitation;


import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.firefly.design.si.*;
import lombok.Data;

@JsonTypeInfo(
        use = JsonTypeInfo.Id.NAME,
        include = JsonTypeInfo.As.EXISTING_PROPERTY,
        property = "type",
        visible = true
)
@JsonSubTypes({
        @JsonSubTypes.Type(value = ImageInvitation.class, name = "image"),
        @JsonSubTypes.Type(value = TurnInvitation.class, name = "page/turn"),
})
@Data
public class Invitation {

    private DocumentType type;

}
