package com.firefly.design.iform.data;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@EqualsAndHashCode(callSuper = false)
@Data()
public class FormObjectItem extends FormItem<Map<String, Object>> {

    //对应前端的表单组
    private List<FormItem> children = Collections.emptyList();

    @Override
    public Map<String, Object> format(Object input) {
        if (input instanceof Map) {
            Map<String, Object> inputMap = (Map<String, Object>) input;

            return children.stream().collect(Collectors.toMap(FormItem::getName, item -> {
                return item.format(inputMap.get(item.getName()));
            }));
        }
        return Collections.emptyMap();
    }
}
