package com.firefly.design.iform.data;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

@EqualsAndHashCode(callSuper = false)
@ToString(callSuper = true)
@Data()
public class FormListItem extends FormItem<List<Object>> {

    private List<FormItem> children;

    @Override
    public List<Object> format(Object input) {
        if (input instanceof List && children != null && children.size() == 1) {
            FormItem child = children.get(0);
            List<Object> inputList = (List<Object>) input;
            return inputList.stream().map(item -> {
                return child.format(item);
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}
