package com.firefly.design.data;


import lombok.Data;

/**
 * 媒体
 * 目前支持 图片 和 视频
 * 如果需要升级，则优化width height参数
 */
@Data
public class MediaFile {

    /**
     * 描述信息
     */
    private int width;

    private int height;

    /**
     * 480P 视频
     * 240P 视频
     * SOURCE 源文件
     */
    private String quality;

    /**
     * image/png
     * image/jpeg
     * image/gif
     * video/mp4
     */
    private String type;

    private String url;

    private String bucket;

    private String key;
}
