package com.firefly.design.data;

import lombok.Data;

@Data
public class LngLat implements Cloneable {

    /**
     * longitude：经度，竖，南北方向
     */
    private Float lng;
    /**
     * latitude: 纬度, 横，东西方向
     */
    private Float lat;

    @Override
    public LngLat clone() {
        try {
            LngLat clone = (LngLat) super.clone();
            clone.setLat(this.lat);
            clone.setLng(this.lng);
            return clone;
        } catch (CloneNotSupportedException e) {
            throw new AssertionError(e);
        }
    }
}
