package com.firefly.design.render.export;


import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.firefly.design.si.*;
import lombok.Data;

@JsonTypeInfo(
        use = JsonTypeInfo.Id.NAME,
        include = JsonTypeInfo.As.EXISTING_PROPERTY,
        property = "type",
        visible = true
)
@JsonSubTypes({
    @JsonSubTypes.Type(value = OSSExportDestination.class, name = "OSS"),
    @JsonSubTypes.Type(value = DownloadExportDestination.class, name = "DOWNLOAD"),
})
@Data
public class ExportDestination {

    private ExportDestinationType type;

    public ExportDestination(ExportDestinationType type) {
        this.type = type;
    }

}
