/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.design.data.configuration;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.firefly.design.si.DocumentType;
import java.io.IOException;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@AutoConfigureBefore(value={JacksonAutoConfiguration.class})
@Configuration
public class DesignDataAutoConfiguration {
    @Bean
    public DesignModule designModule() {
        return new DesignModule();
    }

    public static class DesignModule
    extends SimpleModule {
        public DesignModule() {
            super("Design");
            this.addSerializer(DocumentType.class, (JsonSerializer)new ToStringSerializer(DocumentType.class));
            this.addDeserializer(DocumentType.class, (JsonDeserializer)new DocumentTypeDeserializer());
        }

        public static class DocumentTypeDeserializer
        extends FromStringDeserializer<DocumentType> {
            DocumentTypeDeserializer() {
                super(DocumentType.class);
            }

            protected DocumentType _deserialize(String value, DeserializationContext ctxt) throws IOException {
                return DocumentType.valueOf(value);
            }
        }
    }
}

