package com.firefly.design.data;

import com.firefly.design.si.PageTheme;
import com.firefly.design.si.Picture;
import lombok.Data;

import java.time.Instant;

@Data
public class Page implements Owned {

    private String id;

    private String ownerId;

    private String sourceId;

    private String title;

    private String description;

    private Picture cover;


    private Picture preview;


    private String doctype;

    private String documentId;

    private Instant publishedAt;

    private TargetCensor censor;


    private PageStatistics statistics;


    private PageStatus status;

    private Instant updatedAt;

    private Instant createdAt;

    @Override
    public String ownerId() {
        return this.ownerId;
    }
}
