package com.firefly.design.data;

import com.firefly.design.si.Dimension;
import com.firefly.design.si.DocumentType;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;


@Builder
@Data
public class DocumentDescription {

    private String schema;

    private String version;

    private DocumentType type;

    private Dimension dimension;

    private String md5;

    private long length;

    @Tolerate
    public DocumentDescription() {
    }

    public static DocumentDescription valueOf(
            String schema,
            String version,
            DocumentType type,
            Dimension dimension,
            String md5,
            long length
    ) {
        return DocumentDescription.builder()
                .schema(schema)
                .version(version)
                .type(type)
                .dimension(dimension)
                .md5(md5)
                .length(length)
                .build();
//        return new DocumentDescription(
//                schema,
//                version,
//                type,
//                dimension,
//                md5,
//                length
//        );
    }

}
