package com.firefly.design.si;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Map;

/**
 * 文档
 * 1.
 */

@EqualsAndHashCode(callSuper = true)
@Data
public class ElementDocument extends Document {

    private Element element;

    @Override
    public Dimension dimension() {
        Map<String, Object> properties = element.getProperties();
        Number widthString = (Number) properties.get("width");
        Number heightString = (Number) properties.get("height");
//        if (Strings.isNullOrEmpty(widthString) || Strings.isNullOrEmpty(heightString)) {
//            return null;
//        }

        int width = widthString.intValue();
        int height = heightString.intValue();
        return new Dimension(width, height);
    }
}
