/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.design.data.util;

import com.firefly.design.si.Document;
import com.firefly.design.si.Element;
import com.firefly.design.si.ImageDocument;
import com.firefly.design.si.PageDocument;
import com.firefly.design.si.PageLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class DocumentUtils {
    public static List<String> resolveTexts(Document document) {
        List<Element> elements = Collections.emptyList();
        if (document instanceof ImageDocument) {
            ImageDocument imageDocument = (ImageDocument)document;
            elements = imageDocument.getElements();
        }
        if (document instanceof PageDocument) {
            PageDocument pageDocument = (PageDocument)document;
            elements = new ArrayList<Element>();
            for (PageLayout layout : pageDocument.getLayouts()) {
                elements.addAll(layout.getElements());
            }
        }
        return DocumentUtils.resolve(elements, element -> {
            Map<String, Object> properties = element.getProperties();
            if (properties == null) {
                return null;
            }
            return (String)properties.get("text");
        });
    }

    private static <T> List<T> resolve(List<Element> elements, Function<Element, T> function) {
        if (elements == null || elements.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<T> values = new ArrayList<T>();
        for (Element element : elements) {
            T value = function.apply(element);
            if (value != null) {
                values.add(value);
            }
            List<Element> children = element.getChildren();
            values.addAll(DocumentUtils.resolve(children, function));
        }
        return values;
    }
}

