/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.design.data;

import com.firefly.design.data.ReleaseSNS;
import com.firefly.design.data.SNSType;
import java.util.Objects;
import org.beast.security.core.BytedanceByteappSNSUserToken;
import org.beast.security.core.SNSUserToken;
import org.beast.security.core.WechatWeappSNSUserToken;
import org.springframework.lang.Nullable;

public class ReleaseScene {
    @Nullable
    private ReleaseSNS sns;

    public ReleaseScene() {
    }

    public static ReleaseScene valueOf(SNSUserToken snsUserToken) {
        ReleaseSceneBuilder builder = ReleaseScene.builder();
        if (Objects.nonNull(snsUserToken)) {
            if (snsUserToken instanceof WechatWeappSNSUserToken) {
                WechatWeappSNSUserToken weappSNSUserToken = (WechatWeappSNSUserToken)snsUserToken;
                ReleaseSNS sns = new ReleaseSNS();
                sns.setType(SNSType.WECHAT_WEAPP);
                sns.setAppid(snsUserToken.getAppid());
                sns.setOpenid(weappSNSUserToken.getOpenid());
                builder = builder.sns(sns);
            } else if (snsUserToken instanceof BytedanceByteappSNSUserToken) {
                BytedanceByteappSNSUserToken byteappSNSUserToken = (BytedanceByteappSNSUserToken)snsUserToken;
                ReleaseSNS sns = new ReleaseSNS();
                sns.setType(SNSType.BYTEDANCE_BYTEAPP);
                sns.setAppid(snsUserToken.getAppid());
                sns.setOpenid(byteappSNSUserToken.getOpenid());
                builder = builder.sns(sns);
            }
        }
        return builder.build();
    }

    ReleaseScene(@Nullable ReleaseSNS sns) {
        this.sns = sns;
    }

    public static ReleaseSceneBuilder builder() {
        return new ReleaseSceneBuilder();
    }

    @Nullable
    public ReleaseSNS getSns() {
        return this.sns;
    }

    public void setSns(@Nullable ReleaseSNS sns) {
        this.sns = sns;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReleaseScene)) {
            return false;
        }
        ReleaseScene other = (ReleaseScene)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ReleaseSNS this$sns = this.getSns();
        ReleaseSNS other$sns = other.getSns();
        return !(this$sns == null ? other$sns != null : !((Object)this$sns).equals(other$sns));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ReleaseScene;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ReleaseSNS $sns = this.getSns();
        result = result * 59 + ($sns == null ? 43 : ((Object)$sns).hashCode());
        return result;
    }

    public String toString() {
        return "ReleaseScene(sns=" + this.getSns() + ")";
    }

    public static class ReleaseSceneBuilder {
        private ReleaseSNS sns;

        ReleaseSceneBuilder() {
        }

        public ReleaseSceneBuilder sns(@Nullable ReleaseSNS sns) {
            this.sns = sns;
            return this;
        }

        public ReleaseScene build() {
            return new ReleaseScene(this.sns);
        }

        public String toString() {
            return "ReleaseScene.ReleaseSceneBuilder(sns=" + this.sns + ")";
        }
    }
}

