package com.firefly.design.si;

import java.io.Serializable;
import java.util.Objects;

public class DocumentType implements Serializable {


//    private static final ConcurrentLruCache<String, DocumentType> cachedMimeTypes = new ConcurrentLruCache(64, MimeTypeUtils::parseMimeTypeInternal);
    private final String type;

    private final String subtype;

    public DocumentType(String type, String subtype) {
        this.type = type;
        this.subtype = subtype;
    }

    public DocumentType(String type) {
        this(type, null);
    }

    public String getType() {
        return type;
    }

    public String getSubtype() {
        return subtype;
    }

    public static DocumentType valueOf(String value) {
        return parseDocumentType(value);
    }

    public static DocumentType parseDocumentType(String fullType) {

        int subIndex = fullType.indexOf('/');
        if (subIndex == -1) {
            return new DocumentType(fullType);
        } else {
            String type = fullType.substring(0, subIndex);
            String subtype = fullType.substring(subIndex + 1);
            return new DocumentType(type, subtype);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DocumentType that = (DocumentType) o;
        return Objects.equals(type, that.type) && Objects.equals(subtype, that.subtype);
    }

    @Override
    public int hashCode() {
        return Objects.hash(type, subtype);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.type);
        if (this.subtype != null) {
            builder.append('/');
            builder.append(this.subtype);
        }
        return builder.toString();
    }
}
