package com.firefly.design.data;

import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;
import org.beast.security.core.BytedanceByteappSNSUserToken;
import org.beast.security.core.SNSUserToken;
import org.beast.security.core.WechatWeappSNSUserToken;
import org.springframework.lang.Nullable;

import java.util.Objects;


@Builder
@Data
public class ReleaseScene {

    @Nullable
    private ReleaseSNS sns;

    @Tolerate
    public ReleaseScene() {
    }


    public static ReleaseScene valueOf(SNSUserToken snsUserToken) {
        var builder = ReleaseScene.builder();
        if (Objects.nonNull(snsUserToken)) {
            if (snsUserToken instanceof WechatWeappSNSUserToken weappSNSUserToken) {
                ReleaseSNS sns  = new ReleaseSNS();
                sns.setType(SNSType.WECHAT_WEAPP);
                sns.setAppid(snsUserToken.getAppid());
                sns.setOpenid(weappSNSUserToken.getOpenid());
                builder = builder.sns(sns);
            } else if (snsUserToken instanceof BytedanceByteappSNSUserToken byteappSNSUserToken) {
                ReleaseSNS sns  = new ReleaseSNS();
                sns.setType(SNSType.BYTEDANCE_BYTEAPP);
                sns.setAppid(snsUserToken.getAppid());
                sns.setOpenid(byteappSNSUserToken.getOpenid());
                builder = builder.sns(sns);
            }
        }

        return builder.build();
    }
}
