package com.firefly.design.si;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 邀请函
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class InvitationPageDocument extends Document implements Serializable {

    public static final DocumentType DOCTYPE = DocumentType.valueOf("page/invitation");

    //默认标准  转为viewport width 按比展示
    private Integer width = 750;

    private Integer height = 1000;

    private Envelope envelope;

    private Map<String, String> theme;

    private Background background;

    private Music backgroundMusic;

    private List<PageLayout> layouts = new ArrayList<>();

    @Override
    public Dimension dimension() {
        return new Dimension(width, height);
    }
}
