package com.firefly.design.si;

import java.io.Serializable;
import java.util.Objects;

public class DocType implements Serializable {


//    private static final ConcurrentLruCache<String, DocumentType> cachedMimeTypes = new ConcurrentLruCache(64, MimeTypeUtils::parseMimeTypeInternal);
    private final String type;

    private final String subtype;

    public DocType(String type, String subtype) {
        this.type = type;
        this.subtype = subtype;
    }

    public DocType(String type) {
        this(type, null);
    }

    public String getType() {
        return type;
    }

    public String getSubtype() {
        return subtype;
    }

    public static DocType valueOf(String value) {
        return parseDocumentType(value);
    }

    public static DocType parseDocumentType(String fullType) {

        int subIndex = fullType.indexOf('/');
        if (subIndex == -1) {
            return new DocType(fullType);
        } else {
            String type = fullType.substring(0, subIndex);
            String subtype = fullType.substring(subIndex + 1);
            return new DocType(type, subtype);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DocType that = (DocType) o;
        return Objects.equals(type, that.type) && Objects.equals(subtype, that.subtype);
    }

    @Override
    public int hashCode() {
        return Objects.hash(type, subtype);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.type);
        if (this.subtype != null) {
            builder.append('/');
            builder.append(this.subtype);
        }
        return builder.toString();
    }
}
