package com.firefly.design.si;

import lombok.Data;

import java.io.Serializable;

@Data
public class Background implements Cloneable, Serializable {

    private String color;

    private Image image;

    @Override
    public Background clone() {
        try {
            Background clone = (Background) super.clone();
            clone.setColor(color);
            clone.setImage(image);
            return clone;
        } catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    @Data
    public static class Image {

        /**
         * 0 - 1
         */
        private Float opacity;

        private Integer width;

        private Integer height;

        private String url;

        /**
         * repeat, repeat-x, repeat-y, no-repeat
         */
        private String repeat;

//        /**
//         * cover,contain
//         */
//        private String size;
    }
}
