package com.firefly.design.iform.data;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import lombok.Data;

import java.util.List;

@Data
@JsonTypeInfo(
        use = JsonTypeInfo.Id.NAME,
        include = JsonTypeInfo.As.EXISTING_PROPERTY,
        property = "type",
        visible = true
)
@JsonSubTypes({
        @JsonSubTypes.Type(value = FormFieldItem.class, name = "field"),
        @JsonSubTypes.Type(value = FormListItem.class, name = "list"),
})
public abstract class FormItem<T> {

    //字段类型 允许数组
    private String type;

    private String name;

    private String label;

    private List<FormItemRule> rules;


    public abstract T format(Object input);

}
