package com.firefly.design.data;

import com.firefly.design.si.Dimension;
import com.firefly.design.si.DocumentType;
import com.firefly.design.si.Picture;
import lombok.Data;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@Data
public class Work implements Owned {

//    @JsonProperty(access = JsonProperty.Access.READ_ONLY)
    private String id;

    /**
     * 区分资源
     */
//    @JsonProperty(access = JsonProperty.Access.READ_ONLY)
    private String namespace;

//    @JsonProperty(access = JsonProperty.Access.READ_ONLY)
    private String ownerId;

    //作品名称
    private String title;


//    private String type;

    //封面，预览裁剪的
    private Picture cover;
    //预览
    private Picture preview;

    private Dimension dimension;

    private Map<String, String> metadata = new HashMap<>();


    //引用模板ID
    private String refTemplateId;

    //文档类型
    private DocumentType doctype;

    //
    //300px x 300px
    //200mm x 200mm
    //微标
    //封面

    private String documentId;

    private WorkStatus status;

    private Instant updatedAt;
//    @JsonProperty(access = JsonProperty.Access.READ_ONLY)
    private Instant createdAt;

    @Override
    public String ownerId() {
        return ownerId;
    }
}
